package com.icetech.city.road.domain.table;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.Objects;

/**
 * <p>
 * VIP车辆表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-08-31
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_vip_plate")
public class VipPlate implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * VIP信息表id
     */
    private Integer vipId;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 姓名
     */
    private String owner;

    /**
     * 电话
     */
    private String phone;

    /**
     * 有效开始日期
     */
    private Date startTime;

    /**
     * 有效结束日期
     */
    private Date endTime;

    public Date getStartTime() {
        if (Objects.isNull(startTime)){
            return null;
        }
        return DateUtil.beginOfDay(startTime);
    }

    public Date getEndTime() {
        if (Objects.isNull(endTime)){
            return null;
        }
        return DateUtil.endOfDay(endTime);
    }


}
