package com.icetech.city.road.domain.table;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

/**
 * 第三方推送配置表
 */
@Data
@TableName(value = "`ice_third_push_config`")
public class ThirdPushConfig {
    /**
     * 主键自增长id
     */
    @TableId(value = "`id`")
    protected Integer id;
    /**
     * 第三方名称
     */
    @TableField(value = "`name`")
    protected String name;
    /**
     * 第三方id
     */
    @TableField(value = "`third_pid`")
    protected String thirdPid;
    /**
     * 第三方认账账号
     */
    @TableField(value = "`access_code`")
    protected String accessCode;
    /**
     * 密钥
     */
    @TableField(value = "`secret_key`")
    protected String secretKey;
    /**
     * 推送地址
     */
    @TableField(value = "`push_url`")
    protected String pushUrl;
    /**
     * 备注
     */
    @TableField(value = "`remark`")
    protected String remark;
    /**
     * 额外的参数
     */
    @TableField(value = "`params`")
    protected String params;
    /**
     * 启用标识(0:禁用;1:启用)
     */
    @TableField(value = "`enable_flag`")
    protected Integer enableFlag;
    /**
     * 创建时间
     */
    @TableField(value = "`create_time`")
    protected Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "`update_time`")
    protected Date updateTime;
}
