package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 模版参数表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_template_param_record")
public class TemplateParamRecord {
    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 模版ID
     */
    @TableField("template_id")
    private Long templateId;

    /**
     * 参数ID
     */
    @TableField("param_id")
    private Long paramId;

    /**
     * 参数值
     */
    @TableField("param_value")
    private String paramValue;
}
