package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 优惠记录表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-04-22
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_send_discount")
public class SendDiscount implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 道路id
     */
    private Integer parkId;

    /**
     * 关联商户下发的优惠模板ID
     */
    private Integer merchantDisId;

    /**
     * 优惠券名称
     */
    private String discountName;

    /**
     * 关联商户ID
     */
    private Integer merchantId;

    /**
     * 优惠来源 1:平台发放
     */
    private Integer sourceFrom;

    /**
     * 优惠券编号
     */
    private String discountNo;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 优惠类型1全免2减免时间3减免金额4折扣
     */
    private Integer type;

    /**
     * 优惠内容
     */
    private String amount;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 状态(0未使用1已使用默认0
     */
    private Boolean status;

    /**
     * 单张优惠扣除金额（元）
     */
    private BigDecimal deductMoney;

    /**
     * 领取时间
     */
    private Date sendTime;

    /**
     * 有效开始时间
     */
    private Date startTime;

    /**
     * 有效结束时间
     */
    private Date endTime;

    /**
     * 使用时间
     */
    private Date useTime;

    private Date updateTime;


}
