package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.util.Date;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.icetech.city.road.domain.constant.ValidationGroup;
import lombok.Data;
import org.hibernate.validator.constraints.Range;

@Data
@TableName("ice_mp_user_plate")
public class MpUserPlate implements Serializable {
    public static final int MAX_BIND_PLATE = 5;
    /**
     * ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    protected Long id;
    /**
     * 微信用户ID
     */
    @TableField("user_id")
    protected Long userId;
    /**
     * 车牌号
     */
    @NotBlank(groups = ValidationGroup.Save.class)
    @TableField("plate_num")
    protected String plateNum;
    /**
     * 车牌颜色
     */
    @NotNull(groups = ValidationGroup.Save.class)
    @Range(min = 0, max = 9, groups = ValidationGroup.Save.class)
    @TableField("plate_color")
    protected int plateColor;
    /**
     * 创建时间
     */
    @TableField("create_time")
    protected Date createTime;

    /**
     * 更新时间
     */
    @TableField("update_time")
    protected Date updateTime;
}
