package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

@Data
@TableName("ice_mp_user_advice")
@Accessors(chain = true)
public class MpUserAdvice implements Serializable {
    /** ID */
    @TableId(value = "id", type = IdType.AUTO)
    protected Long id;
    /** 微信用户ID */
    @TableField("user_id")
    protected Long userId;
    /** 车牌号 */
    @TableField("plate_num")
    protected String plateNum;
    /** 联系方式(QQ/电话/邮箱) */
    @TableField("contact_way")
    protected String contactWay;
    /** 反馈内容 */
    @TableField("content")
    protected String content;
    /** 图片链接 */
    @TableField("image")
    protected String image;
    /**
     * 回复状态(0-平台待回复;1-平台已回复;)
     */
    @TableField("`reply_status`")
    protected Integer replyStatus;
    /** 创建时间 */
    @TableField("create_time")
    protected Date createTime;
}
