package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 发票-商户信息表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_invoice_merchant")
public class InvoiceMerchant implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 自增主健id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 企业编码
     */
    private String comCode;

    /**
     * 所属机构
     */
    private Integer institutionId;

    /**
     * 开票方纳税人识别号(15~20位数字或者大写字母)
     */
    private String taxpayerNum;

    /**
     * 税收分类编码
     */
    private String taxCode;

    /**
     * 企业名称
     */
    private String taxpayerName;

    /**
     * 税率
     */
    private Double taxRate;

    /**
     * 注册企业法人代表名称
     */
    private String legalPersonName;

    /**
     * 联系人
     */
    private String contactsName;

    /**
     * 联系人手机号
     */
    private String phone;

    /**
     * 联系人邮箱地址
     */
    private String email;

    /**
     * 省份名称
     */
    private String provinceName;

    /**
     * 市名称
     */
    private String cityName;

    /**
     * 不包含省市名称的地址
     */
    private String address;

    /**
     * 税务登记证图片地址
     */
    private String taxRegistrationCertificate;

    /**
     * 进度状态，1：未注册，2：注册中，3：注册成功，4：注册失败
     */
    private Integer status;

    /**
     * 删除标识
     */
    private Integer deleteStatus;

    /**
     * 收件人名称
     */
    private String clientName;

    /**
     * 收件人地址
     */
    private String clientAddress;

    /**
     * 收件人电话，不限定手机，固话也可以
     */
    private String clientPhone;

    /**
     * 微信卡券模板id
     */
    private String cardId;

    /**
     * 企业平台编码
     */
    private String platformCode;

    /**
     * 企业注册码
     */
    private String registrationCode;

    /**
     * 企业授权码
     */
    private String authorizationCode;

    /**
     * 快递名称
     */
    private String expressName;

    /**
     * 税号
     */
    private String machineNo;

    /**
     * 快递单号
     */
    private String expressNo;

    /**
     * 开票通道 1= 高灯 2= 票通 3=百旺
     */
    private Integer channel;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 银行名称
     */
    private String bankName;

    /**
     * 银行账号
     */
    private String bankNum;

    @TableField(exist = false)
    private Integer parkId;

    /**
     * 税率标识(0-普通;1-免税;2-简易征收;)
     */
    private Integer isFreeTax;

    private String extra;

    public String getAllAddress() {
        return this.provinceName + this.cityName + this.address;
    }

}
