package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 车场心跳断开记录表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-09-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_heartbeat_offline")
public class HeartbeatOffline implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 自增长ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 停车场ID
     */
    private Integer parkId;

    /**
     * 设备表id
     */
    private Integer deviceId;

    /**
     * 设备类型1= 相机 2=地磁 3=pos机 4=巡检车
     */
    private Integer deviceType;

    /**
     * 设备编号
     */
    private String deviceNo;
    /**
     * 设备序列号
     */
    private String devSerialnumber;;
    /**
     * 离线时间
     */
    private Long offlineTime;
    /**
     * 最后连接时间
     */
    private Long lastConnectionTime;

    /**
     * 重新连接时间
     */
    private Long reconnectTime;

    /**
     * 断开总时长（秒）
     */
    private Integer offTime;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;


}
