package com.icetech.city.road.domain.table;

import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_dev_videopile")
public class DevVideopile {
    /** 自增主键id */
    @TableField("id")
    protected Integer id;
    /** 设备编号 */
    @TableField("dev_code")
    protected String devCode;
    /** 所属道路id */
    @TableField("park_id")
    protected Integer parkId;
    /** 设备型号（设备厂家型号表id） */
    @TableField("dev_model")
    protected Integer devModel;
    /** 设备ip */
    @TableField("dev_ipaddr")
    protected String devIpaddr;
    /** 设备序列号（MAC） */
    @TableField("dev_serialnumber")
    protected String devSerialnumber;
    /** 设备状态（1：正常，2：离线，3：故障，默认2） */
    @TableField("dev_status")
    protected Integer devStatus;
    /** 设备位置 */
    @TableField("dev_addr")
    protected String devAddr;
    /** 中心坐标经度 */
    @TableField("centre_longitude")
    protected String centreLongitude;
    /** 中心坐标维度 */
    @TableField("centre_dimension")
    protected String centreDimension;
    /** 最后一次心跳时间（时间戳） */
    @TableField("heartbeat_time")
    protected LocalDateTime heartbeatTime;
    /** 注册标识(0-未注册;1-已注册) */
    @TableField("register_flag")
    protected Integer registerFlag;
    /** 签到用用户 */
    @TableField("sign_in_user")
    protected Integer signInUser;
    /** 签到用SIM卡 */
    @TableField("sign_in_sim")
    protected Integer signInSim;
    /** 签到状态(0-未签到;1-已签到) */
    @TableField("sign_in_status")
    protected Integer signInStatus;
    /** 添加时间 */
    @TableField("create_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime createTime;
    /** 添加人 */
    @TableField("adder")
    protected String adder;
    /** 更新时间 */
    @TableField("update_time")
    @JsonFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime updateTime;
    /** 更新人 */
    @TableField("update_user")
    protected String updateUser;
    /** 描述信息 */
    @TableField("remark")
    protected String remark;
}
