package com.icetech.city.road.domain.table;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 白天夜间收费配置
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_daynight_charge")
public class DaynightCharge implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 计费规则编号 时间+随机数小于16位
     */
    private String billtypecode;

    /**
     * 计费规则名称
     */
    private String billtypename;

    /**
     * 白天计费方式 1：按次计费 2：按时计费
     */
    private Integer billmethodday;

    /**
     * 夜间计费方式 1：按次计费 2：按时计费
     */
    private Integer billmethodnight;

    /**
     * 是否区分工作日非工作日计费 1是 2否 默认为2
     */
    private Integer isspecialdaycharge;

    /**
     * 时段类型 1：工作日 2：非工作日
     */
    private Integer specialdaytype;

    /**
     * 免费时长（分钟）
     */
    private Integer freetime;

    /**
     * 是否使用一天最大收费限额(一天) 0：禁用  1：启用 默认为0
     */
    private Integer daynightmaxfeeusing;

    /**
     * 单天最高收费金额 元
     */
    private BigDecimal daynightmaxfee;

    /**
     * 大型车单天最高收费金额 元
     */
    private BigDecimal daynightmaxfeeBig;

    /**
     * 是否不限制次数进出（daynightmaxfeeusing等于1且车辆停车费用满足最高收费时启用该选项（0：否，限制次数；1：是，不限制次数，一天内车辆任意进出多次只收取一次最高费用；默认0）
     */
    private Integer maxfeetimesusing;

    /**
     * 不限制进出时小型车最高收费金额 元
     */
    private BigDecimal maxfeetimesusingfee;

    /**
     * 不限制进出时大型车最高收费金额 元
     */
    private BigDecimal maxfeetimesusingfeeBig;

    /**
     * 晚上开始计费时间 分钟
     */
    private Integer nightbegin;

    /**
     * 是否启用白天最大收费 1是 2否 默认为2
     */
    private Integer daymaxfeeusing;

    /**
     * 白天最大收费金额 元
     */
    private Integer daymaxfee;

    /**
     * 大型车白天最大收费金额 元
     */
    private Integer daymaxfeeBig;

    /**
     * 是否启用夜间最大收费 1是 2否 默认为2
     */
    private Integer nightmaxfeeusing;

    /**
     * 夜间最大收费金额 元
     */
    private Integer nightmaxfee;

    /**
     * 大型车夜间最大收费金额 元
     */
    private Integer nightmaxfeeBig;

    /**
     * 状态（0：正常，1：删除，默认0）
     */
    private Integer status;

    /**
     * 是否区分大小型车计费（0：否，1：是）默认是0
     */
    private Integer isSmallbigcarSet;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 描述信息
     */
    private String remark;


}
