package com.icetech.city.road.domain.entity.dto;

import java.time.LocalDate;
import java.time.LocalTime;

import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.domain.table.MonthInfo;
import com.icetech.city.road.domain.table.MonthProduct;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
public class MonthCardDto {
    protected Integer productId;
    protected String productName;
    protected Integer infoId;
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    protected LocalDate startDate;
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    protected LocalDate endDate;
    @TemporalFormat(pattern = DateUtils.DEFAULT_TIME_PATTERN)
    protected LocalTime periodStartTime;
    @TemporalFormat(pattern = DateUtils.DEFAULT_TIME_PATTERN)
    protected LocalTime periodEndTime;

    public MonthCardDto(MonthInfoDto info) {
        this.setProductId(info.getProductId())
                .setProductName(info.getProductName())
                .setInfoId(info.getId())
                .setStartDate(DateUtils.toLocalDate(info.getStartTimeOrigin()))
                .setEndDate(DateUtils.toLocalDate(info.getEndTimeOrigin()))
                .setPeriodStartTime(info.getProductStartTime())
                .setPeriodEndTime(info.getProductEndTime());
    }

    public MonthCardDto(MonthProduct product, MonthInfo info) {
        this.setProductId(product.getId())
                .setProductName(product.getName())
                .setInfoId(info.getId())
                .setStartDate(DateUtils.toLocalDate(info.getStartTimeOrigin()))
                .setEndDate(DateUtils.toLocalDate(info.getEndTimeOrigin()))
                .setPeriodStartTime(product.getStartTime())
                .setPeriodEndTime(product.getEndTime());
    }
}
