package com.icetech.city.road.app.undefined.dto;

import com.icetech.city.road.domain.constant.PayChannelConstant;
import com.icetech.city.road.domain.constant.PayWayConstant;
import lombok.Data;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

/**
 * 预下单请求实体类
 * @author wangzhiwei
 */
@Data
public class PrePaymentRequest implements Serializable {
    /**
     * 多个订单号合单支付的时候需要传
     */
    private LinkedHashSet<String> orderNums;
    /**
     * 单个订单支付场景
     */
    private String orderNum;

    /**
     * <pre>
     * 授权链接 微信/支付宝
     * baseUrl+/authentication/pay/auth?agent=1&retUrl=xxx&parkCode=xxx
     * 获取方式retUrl会拼接到uuid参数
     * </pre>
     */
    private String uid;
    /**
     * 支付来源（1：H5）
     */
    private Integer payChannel = PayChannelConstant.H5_QRCODE;
    /**
     * 支付方式（1：微信，2：支付宝）非必填
     */
    private Integer payWay = PayWayConstant.WECHAT;

    /**
     * 请求流水号
     */
    private String tradeNo;

    /**
     * <pre>
     * 要使用的优惠券列表
     * key: orderNum
     * value: couponNo
     * </pre>
     */
    private Map<String, String> coupons = new LinkedHashMap<>();

    public void setOrderNumsList(List<String> orderNums) {
        this.orderNums = new LinkedHashSet<>(orderNums);
    }
}
