/*
 * Decompiled with CFR 0.152.
 */
package com.icetech.city.road.domain.entity.dto;

import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.domain.entity.dto.MonthInfoDto;
import com.icetech.city.road.domain.table.MonthInfo;
import com.icetech.city.road.domain.table.MonthProduct;
import com.icetech.city.road.utils.DateUtils;
import java.time.LocalDate;
import java.time.LocalTime;
import lombok.Generated;

public class MonthCardDto {
    protected Integer productId;
    protected String productName;
    protected Integer infoId;
    @TemporalFormat(pattern="yyyy-MM-dd")
    protected LocalDate startDate;
    @TemporalFormat(pattern="yyyy-MM-dd")
    protected LocalDate endDate;
    @TemporalFormat(pattern="HH:mm:ss")
    protected LocalTime periodStartTime;
    @TemporalFormat(pattern="HH:mm:ss")
    protected LocalTime periodEndTime;

    public MonthCardDto(MonthInfoDto info) {
        this.setProductId(info.getProductId()).setProductName(info.getProductName()).setInfoId(info.getId()).setStartDate(DateUtils.toLocalDate(info.getStartTimeOrigin())).setEndDate(DateUtils.toLocalDate(info.getEndTimeOrigin())).setPeriodStartTime(info.getProductStartTime()).setPeriodEndTime(info.getProductEndTime());
    }

    public MonthCardDto(MonthProduct product, MonthInfo info) {
        this.setProductId(product.getId()).setProductName(product.getName()).setInfoId(info.getId()).setStartDate(DateUtils.toLocalDate(info.getStartTimeOrigin())).setEndDate(DateUtils.toLocalDate(info.getEndTimeOrigin())).setPeriodStartTime(product.getStartTime()).setPeriodEndTime(product.getEndTime());
    }

    @Generated
    public Integer getProductId() {
        return this.productId;
    }

    @Generated
    public String getProductName() {
        return this.productName;
    }

    @Generated
    public Integer getInfoId() {
        return this.infoId;
    }

    @Generated
    public LocalDate getStartDate() {
        return this.startDate;
    }

    @Generated
    public LocalDate getEndDate() {
        return this.endDate;
    }

    @Generated
    public LocalTime getPeriodStartTime() {
        return this.periodStartTime;
    }

    @Generated
    public LocalTime getPeriodEndTime() {
        return this.periodEndTime;
    }

    @Generated
    public MonthCardDto setProductId(Integer productId) {
        this.productId = productId;
        return this;
    }

    @Generated
    public MonthCardDto setProductName(String productName) {
        this.productName = productName;
        return this;
    }

    @Generated
    public MonthCardDto setInfoId(Integer infoId) {
        this.infoId = infoId;
        return this;
    }

    @Generated
    public MonthCardDto setStartDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Generated
    public MonthCardDto setEndDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Generated
    public MonthCardDto setPeriodStartTime(LocalTime periodStartTime) {
        this.periodStartTime = periodStartTime;
        return this;
    }

    @Generated
    public MonthCardDto setPeriodEndTime(LocalTime periodEndTime) {
        this.periodEndTime = periodEndTime;
        return this;
    }

    @Generated
    public String toString() {
        return "MonthCardDto(productId=" + this.getProductId() + ", productName=" + this.getProductName() + ", infoId=" + this.getInfoId() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ", periodStartTime=" + this.getPeriodStartTime() + ", periodEndTime=" + this.getPeriodEndTime() + ")";
    }

    @Generated
    public MonthCardDto() {
    }

    @Generated
    public MonthCardDto(Integer productId, String productName, Integer infoId, LocalDate startDate, LocalDate endDate, LocalTime periodStartTime, LocalTime periodEndTime) {
        this.productId = productId;
        this.productName = productName;
        this.infoId = infoId;
        this.startDate = startDate;
        this.endDate = endDate;
        this.periodStartTime = periodStartTime;
        this.periodEndTime = periodEndTime;
    }
}

