package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.icetech.city.road.component.jackson.TemporalFormat;
import com.icetech.city.road.utils.DateUtils;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@Accessors(chain = true)
@NoArgsConstructor
@AllArgsConstructor
@TableName("ice_spec_car_info")
public class SpecCarInfo implements Serializable {
    private static final long serialVersionUID = 1L;
    /** ID */
    @TableId(type = IdType.AUTO)
    protected Integer id;
    /** 类型ID */
    protected Integer typeId;
    /** 所属人姓名 */
    protected String ownerName;
    /** 所属人手机 */
    protected String ownerPhone;
    /** 开始日期 */
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    protected LocalDate beginDate;
    /** 结束日期 */
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATE_PATTERN)
    protected LocalDate endDate;
    /** 启用标识(0/1) */
    protected Integer enableFlag;
    /** 创建人 */
    @TableField(value = "create_user", updateStrategy = FieldStrategy.NEVER)
    protected String createUser;
    /** 创建时间 */
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    @TableField(value = "create_time", updateStrategy = FieldStrategy.NEVER)
    protected LocalDateTime createTime;
    /** 修改人 */
    protected String updateUser;
    /** 修改时间 */
    @TemporalFormat(pattern = DateUtils.DEFAULT_DATETIME_PATTERN)
    protected LocalDateTime updateTime;

    /**
     * 有效状态(0-未生效;1-已生效;2-已过期)
     * @see #resolveValidState()
     */
    @TableField(exist = false)
    protected Integer validState;

    public SpecCarInfo resolveValidState() {
        if (beginDate != null && endDate != null) {
            long nowDay = LocalDate.now().toEpochDay(),
            beginDay = beginDate.toEpochDay(), endDay = endDate.toEpochDay();
            if (nowDay < beginDay)
                validState = 0;
            else if (nowDay > endDay)
                validState = 2;
            else
                validState = 1;
        }
        return this;
    }
}
