package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Date;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 模块操作日志表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_saas_log")
public class SaasLog implements Serializable {
    private static final long serialVersionUID = 1L;
    /** id */
    protected Long id;
    /** 用户ID */
    protected Integer userId;
    /** 操作记录名称 */
    protected String operateName;
    /** 一级菜单ID */
    protected Integer nodeOneId;
    /** 二级菜单ID */
    protected Integer nodeTwoId;
    /** 操作类型 1:添加,2:编辑,3:删除 */
    protected Integer operationType;
    /** 操作信息 */
    protected String operateInfo;
    /** 操作时间 */
    protected Date operateTime;
    /** 操作设备IP */
    protected String operateDev;
}
