package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 道路关联计费规则表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_park_chargeconfig")
public class ParkChargeconfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 道路id
     */
    private Integer parkId;

    /**
     * 计费规则编号 时间+随机数小于16位
     */
    private String billtypecode;

    /**
     * 计费类型（1：通用自然天，2：白天夜间收费，3：24小时计费）
     */
    private Integer billtype;

    /**
     * 是否默认计费（0：否，1：是，默认0）
     */
    private Integer defaultCharge;

    /**
     * 计费规则名称
     */
    private String billtypename;

    /**
     * 状态（0：正常，1：删除，默认为0）
     */
    private Integer status;

}
