package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.icetech.city.road.utils.StringUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 订单详情表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_order_car_info")
public class OrderCarInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 道路id
     */
    private Integer parkId;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 泊位id
     */
    private Integer berthId;

    /**
     * 车辆品牌
     */
    private String carBrand;

    /**
     * 车辆颜色
     */
    private String carColor;

    /**
     * 车牌颜色
     */
    private String plateColor;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 入场车牌置信度
     */
    private String enterReliability;

    /**
     * 离场车牌置信度
     */
    private String exitReliability;

    /**
     * 入场车辆图片
     */
    private String enterImage;

    /**
     * 出场车辆图片
     */
    private String exitImage;
    /**
     * 入场小图
     */
    @TableField("`enter_small_image`")
    private String enterSmallImage;
    /**
     * 离场小图
     */
    @TableField("`exit_small_image`")
    private String exitSmallImage;
    /**
     * 入场视频
     */
    @TableField("`enter_video`")
    protected String enterVideo;
    /**
     * 离场视频
     */
    @TableField("`exit_video`")
    protected String exitVideo;

    /**
     * 行为
     */
    private Integer behaviorExceptionFlag;

    /**
     * 添加时间
     */
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private Date createTime;

    /**
     * 添加人
     */
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 描述信息
     */
    private String remark;

    public OrderCarInfo appendEnterImage(Collection<String> imageUrls) {
        return setEnterImage(appendImages(enterImage, imageUrls));
    }

    public OrderCarInfo appendEnterSmallImage(Collection<String> imageUrls) {
        return setEnterSmallImage(appendImages(exitSmallImage, imageUrls));
    }

    public OrderCarInfo appendExitImage(Collection<String> imageUrls) {
        return setExitImage(appendImages(exitImage, imageUrls));
    }

    public OrderCarInfo appendExitSmallImage(Collection<String> imageUrls) {
        return setExitSmallImage(appendImages(exitSmallImage, imageUrls));
    }

    private String appendImages(String existsImages, Collection<String> imageUrls) {
        if (imageUrls == null || imageUrls.isEmpty()) return existsImages;
        LinkedHashSet<String> exists = StringUtils.isBlank(existsImages) ?
                new LinkedHashSet<>() : new LinkedHashSet<>(JSON.parseArray(existsImages, String.class));
        exists.addAll(imageUrls);
        return JSON.toJSONString(exists);
    }
}
