package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;

/**
 * <p>
 * 月卡信息表
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-09-03
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_month_info")
public class MonthInfo implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 申办性质 1个人 2公司
     */
    private Integer cardProperty;

    /**
     * 月卡所属人姓名/公司名称
     */
    private String cardOwner;

    /**
     * 手机号码
     */
    private String phone;

    /**
     * 产品id
     */
    private Integer productId;

    /**
     * 主车牌号
     */
    private String mainPlate;

    /**
     * 车位数
     */
    private Integer plotCount;

    /**
     * 购买数量
     */
    private Integer count;

    /**
     * 月卡所售金额
     */
    private BigDecimal saleMoney;

    /**
     * 支付金额
     */
    private BigDecimal payMoney;

    /**
     * 押金
     */
    private BigDecimal deposit;

    /**
     * 支付方式(0 现金，1 银行卡 2：微信 3：支付宝)
     */
    private Integer payMethod;

    /**
     * 月卡有效开始日期
     */
    private Date startTime;

    /**
     * 月卡有效结束日期
     */
    private Date endTime;

    /**
     * 月卡状态 1 生效中 2 待生效 3 已退费 4 已过期 5 冻结 6暂停
     */
    private Integer cardStatus;

    /**
     * 操作人
     */
    private String operAccount;

    /**
     * 备注
     */
    private String remark;

    /**
     * 月卡暂停实际开始时间
     */
    private Date cardstopStart;

    /**
     * 月卡暂停计划结束时间
     */
    private Date cardstopEnd;

    /**
     * 月卡暂停实际结束时间
     */
    private Date cardstopRealyend;

    /**
     * 状态（0：正常，1：删除，默认0）
     */
    private Boolean deleteStatus;

    /**
     * 车主地址
     */
    private String mainAddress;

    /**
     * 月卡第一条信息的id
     */
    private Integer maincardId;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 修改时间
     */
    private Date updateTime;

    public Date getStartTime() {
        if (Objects.isNull(startTime)){
            return null;
        }

        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(startTime);
        calendarEnd.set(Calendar.HOUR_OF_DAY, 0);
        calendarEnd.set(Calendar.MINUTE, 0);
        calendarEnd.set(Calendar.SECOND, 0);
        calendarEnd.set(Calendar.MILLISECOND, 0); // 设置毫秒为0
        return calendarEnd.getTime();
    }

    public Date getEndTime() {
        if (Objects.isNull(endTime)){
            return null;
        }
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(endTime);
        calendarEnd.set(Calendar.HOUR_OF_DAY, 23);
        calendarEnd.set(Calendar.MINUTE, 59);
        calendarEnd.set(Calendar.SECOND, 59);
        calendarEnd.set(Calendar.MILLISECOND, 0); // 设置毫秒为0
        return calendarEnd.getTime();
    }

    public Date getStartTimeOrigin() {
        return startTime;
    }

    public Date getEndTimeOrigin() {
        return endTime;
    }
}
