package com.icetech.city.road.domain.table;

import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDateTime;
import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 异常离位
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-09-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_leave_place_exception")
public class LeavePlaceException implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 车场id
     */
    private Integer parkId;

    /**
     * 泊位id
     */
    private Integer berthId;

    /**
     * 订单编号
     */
    private String orderNum;

    /**
     * 入场方式
     */
    private Integer enterWay;

    /**
     * 入场时间
     */
    private Long enterTime;

    /**
     * pos机离场时间
     */
    private Long posExitTime;

    /**
     * 高位离场时间
     */
    private Long cameraExitTime;
    /**
     * 离位差值(单位/秒)
     */
    private Integer dValue;

    /**
     * 操作人
     */
    private String operater;

    /**
     * 异常离位图片
     */
    private String images;

    private Date createTime;

    private String adder;

    private Date updateTime;

    private String updateUser;

    private String remark;


}
