package com.icetech.city.road.domain.table;

import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * 按时长收费方式
 * </p>
 *
 * @author wangzhiwei
 * @since 2021-03-04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("ice_dyration_config")
public class DyrationConfig implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键自增长id
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    /**
     * 计费规则编号 时间+随机数小于16位
     */
    private String billtypecode;

    /**
     * 收费类型 1：通用自然天收费 2：白天夜间收费
     */
    private Integer isnaturaldayfee;

    /**
     * isnaturaldayfee是1时：是工作日或非工作日计费标识 1：工作日 2非工作日；isnaturaldayfee是2时：是白天或夜间计费标识 1：白天 2夜间
     */
    private Integer dayornightfeemark;

    /**
     * 计时开始时间 分钟
     */
    private Integer startTimeModule;

    /**
     * 计时结束时间 分钟
     */
    private Integer endTimeModule;

    /**
     * 超出多少分钟配置是否起作用 1：是 2否 默认为2
     */
    private Integer isOverTimeSet;

    /**
     * 超过分钟数  分钟
     */
    private Integer overTime;

    /**
     * 单位时间  分钟
     */
    private Integer feespantime;

    /**
     * 单位金额 元
     */
    private BigDecimal feespanrate;

    /**
     * 大型车单位金额 元
     */
    private BigDecimal feespanrateBig;

    /**
     * 添加时间
     */
    private Date createTime;

    /**
     * 添加人
     */
    private String adder;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人
     */
    private String updateUser;

    /**
     * 描述信息
     */
    private String remark;


}
