package com.icetech.city.road.domain.table;

import java.io.Serializable;
import java.math.BigDecimal;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import lombok.experimental.Accessors;

@Getter
@Setter
@ToString
@NoArgsConstructor
@AllArgsConstructor
@Accessors(chain = true)
@TableName("ice_charge_24charge")
public class Charge24Charge implements Serializable {
    /** id */
    @TableId(type = IdType.AUTO)
    protected Integer id;
    /** 计费规则编号 时间+随机数小于16位 */
    protected String billtypecode;
    /** 每间隔多长时间 分钟 */
    protected Integer feespantime;
    /** 单位费用 元 */
    protected BigDecimal feespanrate;
    /** 大型车单位费用 元 */
    protected BigDecimal feespanrateBig;
    /** 免费时段每日最多使用次数, -1表示无限制 */
    protected Integer isFreetimeOnce;
}
