package com.icetech.city.road.domain.entity.request.param;

import com.icetech.city.road.domain.table.Order;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

@Data
public class OrderQueryParam extends Order {
    /**
     * 分页页码
     */
    protected Integer pageNo = 1;
    /**
     * 分页页数
     */
    protected Integer pageSize = 10;

    /**
     * 车牌号筛选
     */
    protected List<String> plateNums;

    /**
     * 入场开始时间
     */
    private Long enterStartTime;
    /**
     * 入场结束时间
     */
    private Long enterEndTime;
    /**
     * 离场开始时间
     */
    private Long exitStartTime;
    /**
     * 离场结束时间
     */
    private Long exitEndTime;
    /**
     * 订单状态
     */
    protected List<Integer> orderStatuses;
    /**
     * 交易状态
     */
    protected List<Integer> payStatuses;
    /**
     * 订单来源
     */
    protected List<Integer> orderSources;

    /**
     * 车场列表ids
     */
    protected List<Integer> parkIds;
    /**
     * 订单类型
     */
    protected List<Integer> orderTypes;
    /**
     * 类型
     */
    protected List<Integer> cardTypes;
    /**
     * 长时停车的停车时长起始查询条件
     */
    protected Long parkingStart;
    /**
     * 长时停车的停车时长结束查询条件
     */
    protected Long parkingEnd;
    /**
     * 不模糊的车牌
     */
    protected String noLikePlateNum;

    /**
     * 异常离位时间
     */
    protected Long exceptionTime;

    protected String fileType;

    /** 月卡套餐名称 */
    protected String monthProductNamePart;
    /** 停车时长(秒) */
    protected Integer parkDurationMin;
    /** 停车时长(秒) */
    protected Integer parkDurationMax;
    /** 入场设备 */
    protected String enterDevicePart;
    protected String exitDevicePart;
    protected String posUsername;
    protected String enterPosUsername;
    protected String exitPosUsername;

    protected Boolean hasUnpaidPrice;
}
