package com.icetech.city.road.domain.entity.request.param;

import lombok.Data;

import jakarta.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 异步通知请求
 *
 * @author wangzw
 *
 **/
@Data
public class NotificationPayRequest implements Serializable {
    /**
     * 交易流水号
     */
    private String tradeNo;
    /**
     * 价格
     */
    private String price;
    /**
     * 状态
     */
    private String tradeStatus;
    /** 支付时间 */
    private Long payTime;
    /**
     * 额外数据包
     */
    @NotNull
    private String extraInfo;
    /**
     * 车场编号
     */
    private String parkCode;

    /**
     * 第三方交易流水号
     */
    private String outTradeNo;

    /**
     * 商户单号
     */
    private String bankOrderId;
}
