package com.icetech.city.road.domain.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 支付方式
 * 10-电子支付
 * 11-电子支付微信
 * 12-电子支付支付宝
 * 13-电子支付银联闪付
 * 20-现金类支付
 * 21-现金支付
 * 22-公交卡
 * 23-银联刷卡
 */
public interface PayWayConstant {
    /**
     * 其他
     */
    Integer OTHER = 0;
    /**
     * 电子支付/在线支付类
     */
    Integer EPAY = 10;
    /**
     * 电子支付微信
     */
    Integer WECHAT = 11;
    /**
     * 电子支付支付宝
     */
    Integer ALIPAY = 12;
    /**
     * 电子支付银联闪付
     */
    Integer UNION_PAY = 13;
    /**
     * 现场支付类
     */
    Integer LOCALE = 20;
    /**
     * 现金支付
     */
    Integer CASH = 21;
    /**
     * 公交卡
     */
    Integer BUS_CARD = 22;
    /**
     * 银联刷卡
     */
    Integer UNION_CARD = 23;
    /**
     * 自动支付/无感支付
     */
    Integer AUTOPAY = 30;
    /**
     * ETC扣款
     */
    Integer ETC_PAY = 31;

    Map<Integer, String> map = new HashMap<Integer, String>() {{
        put(OTHER, "其他");
        put(EPAY, "电子支付/在线支付");
        put(WECHAT, "电子支付微信");
        put(ALIPAY, "电子支付支付宝");
        put(UNION_PAY, "电子支付银联闪付");
        put(LOCALE, "现场支付");
        put(CASH, "现金支付");
        put(BUS_CARD, "公交卡");
        put(UNION_CARD, "银联刷卡");
        put(AUTOPAY, "自动支付/无感支付");
        put(ETC_PAY, "ETC扣款");
    }};
    static String desc(Integer payType){
        return map.get(payType);
    }

}
