package com.icetech.city.road.domain.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * 订单状态
 * @author wangzhiwei
 */
public interface OrderStatusConstant {
    /** 正常 */
    int NORMAL_VAL = 1;
    /** 取消 */
    int CANCEL_VAL = 2;
    /** 异常 */
    int EXCEPTION_VAL = 3;
    /** 删除 */
    int DELETED_VAL = -1;

    /** 正常 */
    Integer NORMAL = NORMAL_VAL;
    /** 取消 */
    Integer CANCEL = CANCEL_VAL;
    /** 异常 */
    Integer EXCEPTION = EXCEPTION_VAL;
    /** 删除 */
    Integer DELETED = DELETED_VAL;

    /** 异常原因-有进无出 */
    String EXCEPTION_DESC_NONE_EXIT = "有进无出";
    /** 异常原因-有出无进 */
    String EXCEPTION_DESC_NONE_ENTER = "有出无进";

    Map<Integer, String> map = new HashMap<Integer, String>() {{
        put(NORMAL, "订单正常");
        put(CANCEL, "订单取消");
        put(EXCEPTION, "订单异常");
        put(DELETED, "订单删除");
    }};
    static String desc(Integer orderStatus){
        return map.get(orderStatus);
    }
}
