package com.icetech.city.road.domain.constant;

import java.util.HashMap;
import java.util.Map;

import lombok.AllArgsConstructor;
import lombok.Getter;

public interface EmpeAtteRecordConsts {
    @Getter
    @AllArgsConstructor
    enum DeviceType {
        POS(1, "POS机");
        private final Integer code;
        private final String name;
        private static final Map<Integer, DeviceType> CODE_MAP = new HashMap<>();

        static {
            for (DeviceType deviceType : DeviceType.values()) {
                CODE_MAP.put(deviceType.getCode(), deviceType);
            }
        }

        public static DeviceType getByCode(Integer code) {
            return CODE_MAP.get(code);
        }

        public static DeviceType getByCode(Integer code, DeviceType def) {
            return CODE_MAP.getOrDefault(code, def);
        }

        public static String getNameByCode(Integer code) {
            return getNameByCode(code, null);
        }

        public static String getNameByCode(Integer code, String def) {
            DeviceType type = CODE_MAP.get(code);
            return type == null ? def : type.getName();
        }
    }

    @Getter
    @AllArgsConstructor
    enum CheckType {
        LOGIN(1, "签到"), LOGOUT(2, "签退");
        private final Integer code;
        private final String name;
        private static final Map<Integer, CheckType> CODE_MAP = new HashMap<>();

        static {
            for (CheckType checkType : CheckType.values()) {
                CODE_MAP.put(checkType.getCode(), checkType);
            }
        }

        public static CheckType getByCode(Integer code) {
            return CODE_MAP.get(code);
        }

        public static CheckType getByCode(Integer code, CheckType def) {
            return CODE_MAP.getOrDefault(code, def);
        }

        public static String getNameByCode(Integer code) {
            return getNameByCode(code, null);
        }

        public static String getNameByCode(Integer code, String def) {
            CheckType type = CODE_MAP.get(code);
            return type == null ? def : type.getName();
        }
    }

    @Getter
    @AllArgsConstructor
    enum CheckResult {
        SUCCESS(0, "成功"),
        COME_LATE(1, "迟到"),
        LEAVE_EARLY(2, "早退"),
        OUT_OF_RANGE(3, "超范围"),
        NO_CHECK(4, "未打卡");
        private final Integer code;
        private final String name;
        private static final Map<Integer, CheckResult> CODE_MAP = new HashMap<>();

        static {
            for (CheckResult checkResult : CheckResult.values()) {
                CODE_MAP.put(checkResult.getCode(), checkResult);
            }
        }

        public static CheckResult getByCode(Integer code) {
            return CODE_MAP.get(code);
        }

        public static CheckResult getByCode(Integer code, CheckResult def) {
            return CODE_MAP.getOrDefault(code, def);
        }

        public static String getNameByCode(Integer code) {
            return getNameByCode(code, null);
        }

        public static String getNameByCode(Integer code, String def) {
            CheckResult result = CODE_MAP.get(code);
            return result == null ? def : result.getName();
        }
    }
}
