package com.icetech.city.road.component.constant;

import lombok.Getter;


/**
 * @author fangct
 */
@Getter
public enum CodeConstantsEnum {
    SUCCESS("200","成功"),
    ERROR("500","服务器异常"),
    ERROR_400("400", "缺失参数/格式不正确"),
    ERROR_401("401", "认证失败"),
    ERROR_402("402", "非法参数"),
    ERROR_403("403", "请求方式错误"),
    ERROR_403_11("403.11", "原密码错误"),
    ERROR_404("404", "请求资源不存在"),
    ERROR_405("405", "请求重复"),
    ERROR_1100("1100", "下单系统异常"),
    ERROR_1200("1200","类型不正确"),
    ERROR_2100("2100", "无感支付业务失败"),
    ERROR_2001("2001", "无感支付业务失败"),
    ERROR_2002("2002" ,"用户未授权无感支付"),
    ERROR_2003("2003" ,"退款状态不合法"),
    ERROR_2004("2004" ,"车辆有未离场记录"),
    ERROR_2005("2005" ,"退款金额不合法"),
    ERROR_2006("2006","车场未开通此功能"),
    ERROR_3001("3001" ,"查询费用失败"),
    ERROR_3002("3002" ,"开闸失败"),
    ERROR_510("510" ,"优惠券不在有效期"),
    ERROR_610("610" ,"验证码失效或不正确"),
    ERROR_620("620" ,"验证码发送失败"),
    ERROR_710("710" ,"月卡续租失败"),

    // -- 成功 000000
    // 00 00 00    6位编码, 2个为1级, 分为3级
    // 90 00 00    系统级编码
    // 00-01 00 00    基础数据信息

    // 10 00 00 订单相关信息
    ORDER_NOT_FOUND("100000", "订单不存在"),
    // 10 01 00-99 订单状态
    ORDER_STATUS_ENTER("100100", "订单已在场"),
    ORDER_STATUS_EXIT("100101", "订单已离场"),
    ORDER_STATUS_NORMAL("100103", "订单状态正常"),
    ORDER_STATUS_ABNORMAL("100104", "订单状态异常"),
    ORDER_ALREADY_PAY("100105", "订单已支付"),

    // 20 01 00-99 POS机相关
    BERTH_NONE_ORDER("200110", "泊位无订单"),
    BERTH_ORDER_CHANGED("200111", "泊位订单发生变化"),
    BERTH_PLATE_CHANGED("200112", "泊位车牌发生变化"),
    ;
    private final String code;
    private final String desc;
    CodeConstantsEnum(String code, String desc){
        this.code = code;
        this.desc = desc;
    }
}
