package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 宁波银行财资转账明细表 实体类
 */
@Data
@TableName("ice_transaction_detail")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class TransactionDetail implements Serializable {

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 转账记录号
     */
    @TableField("transaction_code")
    private String transactionCode;
    /**
     * 车场id
     */
    @TableField("park_id")
    private Long parkId;
    /**
     * 车场编号
     */
    @TableField("park_code")
    private String parkCode;
    /**
     * 车场类型:1场库;2路内
     */
    @TableField("park_type")
    private Integer parkType;
    /**
     * 支付方式
     */
    @TableField("pay_way")
    private String payWay;
    /**
     * 类型:1:支付;2退款
     */
    @TableField("type")
    private Integer type;
    /**
     * 车牌号
     */
    @TableField("plate_num")
    private String plateNum;
    /**
     * 车牌颜色
     */
    @TableField("plate_color")
    private String plateColor;
    /**
     * 支付金额
     */
    @TableField("pay_price")
    private BigDecimal payPrice;
    /**
     * 业务编号
     */
    @TableField("trade_no")
    private String tradeNo;
    /**
     * 订单号
     */
    @TableField("order_num")
    private String orderNum;
    /**
     * 支付时间
     */
    @TableField("pay_date")
    private Date payDate;
    /**
     * 订单类型:1:临停; 2:月卡
     */
    @TableField("order_type")
    private Integer orderType;
    /**
     * 套餐名称
     */
    @TableField("product_name")
    private String productName;
    /**
     * 手机号
     */
    @TableField("phone")
    private String phone;
    /**
     * 购买人
     */
    @TableField("car_owner")
    private String carOwner;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
}