package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 商户表 实体类
 */
@Data
@TableName("ice_merchant")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class Merchant implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 商户名称
     */
    @TableField("name")
    private String name;
    /**
     * 商户号
     */
    @TableField("code")
    private String code;
    /**
     * 商户手机号
     */
    @TableField("phone")
    private String phone;
    /**
     * 是否可透支余额:0否;1是
     */
    @TableField("overdraw_flag")
    private Integer overdrawFlag;
    /**
     * 可透支金额
     */
    @TableField("overdraw_amount")
    private BigDecimal overdrawAmount;
    /**
     * 余额
     */
    @TableField("balance")
    private BigDecimal balance;
    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
    /**
     * 操作人
     */
    @TableField("operator")
    private String operator;
    /**
     * 删除标识:0未删除;1已删除
     */
    @TableField("deleted")
    private Integer deleted;

    public static final Integer OVERDRAW_FLAG_YES = 1;
    public static final Integer OVERDRAW_FLAG_NO = 0;
}