package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import java.io.Serializable;

/**
 * 黑白名单适用车场 实体类
 */
@Data
@TableName("ice_blacklist_park")
public class BlacklistPark implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 黑白名单ID
     */
    @TableField("blacklist_id")
    private Long blacklistId;
    /**
     * 车场ID
     */
    @TableField("park_id")
    private Long parkId;
    /**
     * 车场类型(1-厂库;2-路内)
     */
    @TableField("park_type")
    private Integer parkType;
    /**
     * 车场编码
     */
    @TableField("park_code")
    private String parkCode;

    public static final Integer PARK_TYPE_PARK = 1;
    public static final Integer PARK_TYPE_ROAD = 2;
}