package com.icetech.city.common.domain.dto;

import com.opencsv.bean.CsvBindByPosition;
import com.opencsv.bean.CsvDate;
import com.opencsv.bean.CsvNumber;
import lombok.Data;

import java.util.Date;

@Data
public class TaskOrderDelinquentDto {

    /**
     * 订单号
     */
    @CsvBindByPosition(position = 0)
    private String orderNum;

    /**
     * 所属车场
     */
    @CsvBindByPosition(position = 1)
    private String parkName;

    /**
     * 车场类型
     * 1-场库，2-路内
     */
    @CsvBindByPosition(position = 2)
    private String parkTypeStr;

    /**
     * 车牌号
     */
    @CsvBindByPosition(position = 3)
    private String plateNum;

    /**
     * 车牌颜色
     * 0=未知,1=蓝底白字,2=黄底黑字,3=白底黑字,4=黑底白字,6=绿底黑字,7=绿黄底黑字
     */
    @CsvBindByPosition(position = 4)
    private String plateColorStr;

    /**
     * 入场时间
     */
    @CsvDate(value = "yyyy-MM-dd HH:mm:ss")
    @CsvBindByPosition(position = 5)
    private Date enterDate;

    /**
     * 离场时间
     */
    @CsvDate(value = "yyyy-MM-dd HH:mm:ss")
    @CsvBindByPosition(position = 6)
    private Date exitDate;

    /**
     * 停车时长(秒)
     */
    @CsvBindByPosition(position = 7)
    private String durationStr;

    /**
     * 车辆类型
     */
    @CsvBindByPosition(position = 8)
    private String cardTypeStr;

    /**
     * 车型
     */
    @CsvBindByPosition(position = 9)
    private String carTypeStr;

    /**
     * 应付金额
     */
    @CsvBindByPosition(position = 10)
    private String totalPrice;

    /**
     * 已缴金额
     */
    @CsvBindByPosition(position = 11)
    private String paidPrice;

    /**
     * 欠费金额
     */
    @CsvBindByPosition(position = 12)
    private String outStandPrice;

    /**
     * 优惠金额
     */
    @CsvBindByPosition(position = 13)
    private String discountPrice;

    /**
     * 退款金额
     */
    @CsvBindByPosition(position = 14)
    private String refundPrice;


}
