package com.icetech.city.common.domain.dto;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class OrderDelinquentDto {

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 所属车场
     */
    private String parkName;

    /**
     * 车场类型
     * 1-场库，2-路内
     */
    private Integer parkType;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 车牌颜色
     * 0=未知,1=蓝底白字,2=黄底黑字,3=白底黑字,4=黑底白字,6=绿底黑字,7=绿黄底黑字
     */
    private Integer plateColor;

    /**
     * 入场时间
     */
    private long enterTime;

    /**
     * 离场时间
     */
    private long exitTime;

    /**
     * 停车时长(秒)
     */
    private long duration;

    /**
     * 车辆类型
     */
    private Integer cardType;

    /**
     * 车型
     */
    private Integer carType;

    /**
     * 应付金额
     */
    private BigDecimal totalPrice;

    /**
     * 已缴金额
     */
    private BigDecimal paidPrice;

    /**
     * 欠费金额
     */
    private BigDecimal outStandPrice;

    /**
     * 优惠金额
     */
    private BigDecimal discountPrice;

    /**
     * 退款金额
     */
    private BigDecimal refundPrice;
}
