package com.icetech.city.common.domain.dto;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class LargeOrderDto {

    /**
     * id
     */
    private Integer id;

    /**
     * 道路/停车场名称
     */
    private String parkName;

    /**
     * 业务编号
     */
    private String orderNum;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 入场时间
     */
    private Long enterTime;

    /**
     * 离场时间
     */
    private Long exitTime;

    /**
     * 停留时长
     */
    private Long duration;

    /**
     * 车辆辆类型（1：临时车，99：未知，默认1）
     */
    private Integer cardType;

    /**
     * 车型（1：小型车，2：大型车，默认1）
     */
    private Integer carType;

    /**
     * 出口通道名称
     */
    private String exitChannelName;

    /**
     * 泊位号
     */
    private String berthCode;

    /**
     * 离场方式
     */
    private Integer exitWay;

    /**
     * 离位设备
     */
    private String exitDevice;

    /**
     * 应收金额
     */
    private BigDecimal totalPrice;

    /**
     * 实收金额
     */
    private BigDecimal paidPrice;

    /**
     * 优惠金额
     */
    private BigDecimal discountPrice;

    /**
     * 退款金额
     */
    private BigDecimal refundPrice;

    /**
     * 异常离场
     */
    private String errorCauses;

    /**
     * 欠费金额
     */
    private BigDecimal unpaidPrice;

    /**
     * 车场类型 1-场库，2-路内
     */
    private Integer parkType;

    /**
     * 订单阈值
     */
    private BigDecimal orderBigAmt;
}
