package com.icetech.city.common.domain.dto;

import lombok.Data;

/**
 * @author wgq
 */
@Data
public class DownSpecCarInfoDto {

    /**
     * 操作类型1=添加 2=修改 3=删除
     */
    private Integer operType;

    /**
     * 操作时间（unix时间戳）
     */
    private Long operTime;

    /**
     * 自定义优惠车辆类型ID
     */
    private String vipCarTypeId;

    /**
     * 自定义优惠车辆类型编号
     */
    private String vipCarTypeNo;

    /**
     * 自定义优惠车辆类型名称
     */
    private String vipCarTypeName;

    /**
     * 自定义优惠信息表ID
     */
    private Integer vipInfoId;

    /**
     * 有效期开始日期
     */
    private String startDate;

    /**
     * 有效期结束日期，格式为yyyy-MM-dd
     * 如2017-07-31
     */
    private String endDate;

    /**
     * 车主姓名
     */
    private String owner;

    /**
     * 车主电话
     */
    private String phone;

    /**
     * 车牌号,可以多个。会以"/"连接。比如车牌号信息：京JS7680/京JS7681/京JS7682/京JS7683/京JS7684/京JS7685
     */
    private String plateNums;
}
