package com.icetech.city.common.api;

import com.icetech.city.common.domain.dto.SpecCarTypeDto;
import com.icetech.city.common.domain.entity.common.SpecCarType;

import java.util.Date;

public interface SpecCarTypeApi {

    /**
     * 通过优惠类型ID查询优惠类型信息
     *
     * @param typeId 优惠类型ID
     * @return 优惠类型
     */
    SpecCarTypeDto getSpecCarTypeByTypeId(Integer typeId);

    /**
     * 通过优惠信息的ID获取优惠类型
     *
     * @param carInfoId 优惠车辆ID
     * @return SpecCarType
     */
    SpecCarType getSpecCarTypeByCarInfoId(Integer carInfoId);

    /**
     * 根据车场ID 类型 车牌 时间获取类型
     *
     * @param parkId    车场ID
     * @param parkType  车场类型 1-场库，2-路内
     * @param plateNum  车牌
     * @param validDate 时间
     * @return SpecCarType
     */
    SpecCarType getSpecCarTypeByParkIdAndParkTypeAndPlateNum(Long parkId, Integer parkType, String plateNum, Date validDate);
}
