package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 *  实体类
 */
@Data
@TableName("ice_task_download")
public class TaskDownload implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 任务名称
     */
    @TableField("task_name")
    private String taskName;
    /**
     * 下载地址
     */
    @TableField("task_add")
    private String taskAdd;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
    /**
     * 用户ID
     */
    @TableField("user_id")
    private Integer userId;
    /**
     * 0-执行失败，1-执行成功，2-待执行，3-执行中
     */
    @TableField("task_status")
    private Integer taskStatus;
}