package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 月卡过期前发短信规则表 实体类
 */
@Data
@TableName("ice_sms_alarm_rule_month")
public class SmsAlarmRuleMonth implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 车场编码
     */
    @TableField("park_code")
    private String parkCode;
    /**
     * 提前天数
     */
    @TableField("before_expire_days")
    private Integer beforeExpireDays;
    /**
     * 报警频率(0-单次;1-每天;2-隔天;)
     */
    @TableField("frequency")
    private Integer frequency;
    /**
     * 发送时间点
     */
    @TableField("send_time")
    @JsonFormat(pattern = "HH:mm", timezone = "GMT+8")
    private Date sendTime;
    /**
     * 最多发送次数
     */
    @TableField("max_count")
    private Integer maxCount;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    /**
     * 更新人
     */
    @TableField("update_user")
    private String updateUser;
}