package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 优惠信息表 实体类
 */
@Data
@TableName("ice_coupon")
public class Coupon implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 商户ID
     */
    @TableField("merchant_id")
    private Long merchantId;
    /**
     * 优惠券码
     */
    @TableField("coupon_code")
    private String couponCode;
    /**
     * 优惠券名称
     */
    @TableField("coupon_name")
    private String couponName;
    /**
     * 优惠类型 1-时长券 2-代金券 3-全免券
     */
    @TableField("coupon_type")
    private Integer couponType;
    /**
     * 优惠信息
     */
    @TableField("coupon_msg")
    private BigDecimal couponMsg;
    /**
     * 操作人ID
     */
    @TableField("create_user")
    private String createUser;
    /** 扣除方式(1-领取优惠后扣除余额;2-按计费金额扣除余额) */
    @TableField("deduct_method")
    private Integer deductMethod;
    /** 商家扣除金额 */
    @TableField("merchant_deducted_amount")
    private BigDecimal merchantDeductedAmount;
    /** 商家扣除折扣 */
    private BigDecimal deductDisc;
    /**
     * 支持静态码 1-支持，0不支持
     */
    @TableField("qr_code_type")
    private Integer qrCodeType;
    /**
     * 动态码刷新时间 【分钟】
     */
    @TableField("dynamic_qr_code")
    private Integer dynamicQrCode;
    /**
     * 使用时效 【小时】
     */
    @TableField("use_time")
    private Integer useTime;
    /**
     * 车场类型 1-全车场 , 2自定义车场
     */
    @TableField("park_type")
    private Integer parkType;
    /**
     * 更新时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    public static final Integer PARK_TYPE_ALL = 1;
    public static final Integer PARK_TYPE_CUSTOM = 2;

    /** 时长券 */
    public static final Integer COUPON_TYPE_TIME = 1;
    /** 代金券 */
    public static final Integer COUPON_TYPE_AMOUNT = 2;
    /** 全免券 */
    public static final Integer COUPON_TYPE_ALL = 3;

    /** 扣除方式 - 领取时扣除 */
    public static final Integer DEDUCT_METHOD_GET = 1;
    /** 扣除方式 - 按计费扣除 */
    public static final Integer DEDUCT_METHOD_CALC_FEE = 2;
}