package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 *  实体类
 */
@Data
@TableName("ice_blacklist")
public class Blacklist implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 车牌
     */
    @TableField("plate_num")
    private String plateNum;
    /**
     * 车牌颜色 0-未知, 1-蓝底白字, 2-黄底黑字, 3-白底黑字, 4-黑底白字, 5-绿底黑字 6-绿黄底黑字
     */
    @TableField("plate_color")
    private Integer plateColor;
    /**
     * 车辆类型 0-黑名单, 1-白名单
     */
    @TableField("plate_type")
    private Integer plateType;
    /**
     * 姓名
     */
    @TableField("name")
    private String name;
    /**
     * 联系电话
     */
    @TableField("phone")
    private String phone;
    /**
     * 起止时间
     */
    @TableField("start_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startTime;
    /**
     * 截止时间
     */
    @TableField("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endTime;
    /**
     * 状态 0-禁用 1-启用
     */
    @TableField("status")
    private Integer status;
    /**
     * 下发状态 0-失败，1-成功
     */
    @TableField("delivery_status")
    private Integer deliveryStatus;
    /**
     * 原因
     */
    @TableField("reason")
    private String reason;
    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
    /**
     * 备注
     */
    @TableField("user_name")
    private String userName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /** 车牌类型-空类型 */
    public static final Integer PLATE_TYPE_NULL = -1;
    /** 车牌类型-黑名单 */
    public static final Integer PLATE_TYPE_BLACK = 0;
    /** 车牌类型-白名单 */
    public static final Integer PLATE_TYPE_WHITE = 1;

    /** 状态-禁用 */
    public static final Integer STATUS_DISABLE = 0;
    /** 状态-启用 */
    public static final Integer STATUS_ENABLE = 1;
}