package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 宁波银行转账规则表 实体类
 */
@Data
@TableName("ice_transfer_rule")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class TransferRule implements Serializable {


    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 车场id
     */
    @TableField("park_id")
    private Long parkId;
    /**
     * 车场编号
     */
    @TableField("park_code")
    private String parkCode;
    /**
     * 车场类型:1场库;2路内
     */
    @TableField("park_type")
    private Integer parkType;
    /**
     * 转账规则编号
     */
    @TableField("code")
    private String code;
    /**
     * 客户号
     */
    @TableField("cust_id")
    private String custId;
    /**
     * 单位代码
     */
    @TableField("corp_code")
    private String corpCode;
    /**
     * 付款方账号
     */
    @TableField("pay_acc")
    private String payAcc;
    /**
     * 收款方行名
     */
    @TableField("rcv_acc")
    private String rcvAcc;
    /**
     * 收款方行名
     */
    @TableField("rcv_bank_name")
    private String rcvBankName;
    /**
     * 收款户名
     */
    @TableField("rcv_name")
    private String rcvName;

    /**
     * 用途
     */
    @TableField("purpose")
    private String purpose;


    /**
     * 是否短信通知收款人:0:不通知;1:通知
     */
    @TableField("tell_rev")
    private Integer tellRev;


    /**
     * 收款方手机号
     */
    @TableField("rcv_mobile")
    private String rcvMobile;

    /**
     * 转账比例
     */
    @TableField("transfer_ratio")
    private BigDecimal transferRatio;
    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
    /**
     * 操作人
     */
    @TableField("operator")
    private String operator;
    /**
     * 删除标识:0未删除;1已删除
     */
    @TableField("deleted")
    private Integer deleted;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
}