package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 短信模板表 实体类
 */
@Data
@TableName("ice_sms_alarm_template")
public class SmsAlarmTemplate implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 车场ID(0为默认)
     */
    @TableField("park_code")
    private String parkCode;
    /**
     * 模板类型(1-月卡临期提醒;2-特殊车辆提醒开关)
     */
    @TableField("type")
    private Integer type;
    /**
     * 模板名称
     */
    @TableField("name")
    private String name;
    /**
     * 车场类型 1-场库，2-路内
     */
    @TableField("park_type")
    private Integer parkType;
    /**
     * 模板内容
     */
    @TableField("content")
    private String content;
    /**
     * 阿里模板id
     */
    @TableField("template_code")
    private String templateCode;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
    /**
     * 更新人
     */
    @TableField("update_user")
    private String updateUser;
}