package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单表 实体类
 */
@Data
@TableName("ice_order")
public class GarageOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 订单号
     */
    @TableField("order_num")
    private String orderNum;
    /**
     * 车场id
     */
    @TableField("park_id")
    private Integer parkId;
    /**
     * 车牌号
     */
    @TableField("plate_num")
    private String plateNum;
    /**
     * 车辆类型(1临时车2月卡车3特殊车辆，默认1)
     */
    @TableField("type")
    private Integer type;
    /**
     * 区域id
     */
    @TableField("region_id")
    private Integer regionId;
    /**
     * 是否有子订单，0：否，1：是，默认为0
     */
    @TableField("has_son")
    private Byte hasSon;
    /**
     * 进场时间
     */
    @TableField("enter_time")
    private Integer enterTime;
    /**
     * 离场时间
     */
    @TableField("exit_time")
    private Integer exitTime;
    /**
     * 车型(2大型车、1小型车，默认1)
     */
    @TableField("car_type")
    private Integer carType;
    /**
     * 总应收金额
     */
    @TableField("total_price")
    private BigDecimal totalPrice;
    /**
     * 总实收金额
     */
    @TableField("paid_price")
    private BigDecimal paidPrice;
    /**
     * 总优惠金额
     */
    @TableField("discount_price")
    private BigDecimal discountPrice;
    /**
     * 订单状态（1在场2离场3已取消4异常记录）
     */
    @TableField("service_status")
    private Integer serviceStatus;
    /**
     * 订单状态为4时异常原因
     */
    @TableField("odd_status")
    private Integer oddStatus;
    /**
     * 操作员
     */
    @TableField("oper_account")
    private String operAccount;
    /**
     * 预交费时间
     */
    @TableField("prepay_time")
    private Integer prepayTime;
    /**
     * 预交费实收金额
     */
    @TableField("prepay_amount")
    private BigDecimal prepayAmount;
    /**
     * AB车切换时间
     */
    @TableField("switch_time")
    private Integer switchTime;
    /**
     * 去汉字车牌
     */
    @TableField("plate_num2")
    private String plateNum2;
    /**
     * 本地订单号
     */
    @TableField("local_order_num")
    private String localOrderNum;
    /**
     * 车辆描述 
     */
    @TableField("car_desc")
    private String carDesc;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 储值卡扣除金额
     */
    @TableField("balance_price")
    private BigDecimal balancePrice;
    /**
     * 是否通过城市大脑扣费 0=否 1=是 默认0
     */
    @TableField("city_autopay")
    private Integer cityAutopay;
    /**
     * 待缴费金额，先离场后付费用
     */
    @TableField("need_price")
    private BigDecimal needPrice;
    /**
     * 无入场记录标识(0=否;1=是)
     */
    @TableField("none_enter_flag")
    private Byte noneEnterFlag;
    /**
     * 
     */
    @TableField("enter_channel_id")
    private String enterChannelId;
    /**
     * 
     */
    @TableField("exit_channel_id")
    private String exitChannelId;
    /**
     * 退款金额
     */
    @TableField("refund_price")
    private BigDecimal refundPrice;
    /**
     * 异常或取消原因
     */
    @TableField("error_causes")
    private String errorCauses;
}