package com.icetech.city.common.domain.dto;

import lombok.Data;

import java.math.BigDecimal;

@Data
public class DelinquentSonOnParkDto {

    /**
     *业务编号
     */
    private String orderNum;

    /**
     * 所属车场
     */
    private String parkName;

    /**
     * 车场类型
     */
    private Integer parkType;

    /**
     * 车牌号
     */
    private String plateNum;

    /**
     * 车牌颜色
     * 0=未知,1=蓝底白字,2=黄底黑字,3=白底黑字,4=黑底白字,6=绿底黑字,7=绿黄底黑字
     */
    private Integer plateColor;

    private String plateColorStr;

    /**
     * 入场时间
     */
    private long enterTime;

    /**
     * 车辆类型
     */
    private Integer cardType;

    /**
     * 车型
     */
    private Integer carType;

    /**
     * 已缴金额
     */
    private BigDecimal paidPrice;

    /**
     * 优惠金额
     */
    private BigDecimal discountPrice;


}
