package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 宁波银行财资转账操作明细记录表 实体类
 */
@Data
@TableName("ice_transaction_operator_log")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class TransactionOperatorLog implements Serializable {

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 转账记录id
     */
    @TableField("transaction_id")
    private Long transactionId;
    /**
     * 车场id
     */
    @TableField("park_id")
    private Long parkId;
    /**
     * 车场编号
     */
    @TableField("park_code")
    private String parkCode;
    /**
     * 车场类型:1场库;2路内
     */
    @TableField("park_type")
    private Integer parkType;
    /**
     * 状态:1已转账;2转账失败
     */
    @TableField("status")
    private Integer status;
    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

    /**
     * 失败原因
     */
    @TableField("fail_msg")
    private String failMsg;
    /**
     * 交易流水号
     */
    @TableField("trade_no")
    private String tradeNo;
    /**
     * 操作人
     */
    @TableField("operator")
    private String operator;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
}