package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 特殊车辆类型 实体类
 */
@Data
@TableName("ice_spec_car_type")
public class SpecCarType implements Serializable {

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 类型名称
     */
    @TableField("type_name")
    private String typeName;
    /**
     * 优惠类型(0-无;1-全免;2-减免时长;3-减免金额;4-折扣)
     */
    @TableField("disc_type")
    private Integer discType;
    /**
     * 优惠值
     */
    @TableField("disc_value")
    private String discValue;
    /**
     * 启用标识(0/1)
     */
    @TableField("enable_flag")
    private Integer enableFlag = 1;
    /**
     * 创建人
     */
    @TableField("create_user")
    private String createUser;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 修改人
     */
    @TableField("update_user")
    private String updateUser;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
}