package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * 优惠券使用记录 实体类
 */
@Data
@Accessors(chain = true)
@TableName("ice_coupon_use_record")
public class CouponUseRecord implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 商户id
     */
    @TableField("merchant_id")
    private Long merchantId;

    /**
     * 优惠券ID
     */
    @TableField("coupon_id")
    private Long couponId;
    /** 领取记录ID */
    @TableField("grant_id")
    private Long grantId;
    /**
     * 用户手机号
     */
    @TableField("user_phone")
    private String userPhone;
    /**
     * 使用时间
     */
    @TableField("use_time")
    private LocalDateTime useTime;
    /**
     * 车场ID
     */
    @TableField("park_id")
    private Long parkId;
    /**
     * 订单来源(1-厂库;2-路内)
     */
    @TableField("order_source")
    private Integer orderSource;
    /**
     * 订单号
     */
    @TableField("order_num")
    private String orderNum;
    /** 支付流水号 */
    @TableField("trade_no")
    private String tradeNo;
    /**
     * 车牌号
     */
    @TableField("plate_num")
    private String plateNum;
    /**
     * 订单入场时间
     */
    @TableField("enter_time")
    private LocalDateTime enterTime;
    /**
     * 订单离场时间
     */
    @TableField("exit_time")
    private LocalDateTime exitTime;
    /**
     * 实际优惠金额
     */
    @TableField("discount_amount")
    private BigDecimal discountAmount;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
}