package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 宁波银行转账规则操作记录表 实体类
 */
@Data
@TableName("ice_transfer_rule_log")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class TransferRuleLog implements Serializable {

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 车场id
     */
    @TableField("park_id")
    private Long parkId;
    /**
     * 车场编号
     */
    @TableField("park_code")
    private String parkCode;
    /**
     * 车场类型:1场库;2路内
     */
    @TableField("park_type")
    private Integer parkType;
    /**
     * 转账规则id
     */
    @TableField("transfer_id")
    private Long transferId;
    /**
     * 转账规则编号
     */
    @TableField("transfer_code")
    private String transferCode;
    /**
     * 类型:1添加;2编辑;3删除
     */
    @TableField("type")
    private Integer type;
    /**
     * 内容
     */
    @TableField("content")
    private String content;
    /**
     * 操作人
     */
    @TableField("operator")
    private String operator;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
    /**
     * 删除标识:0未删除;1已删除
     */
    @TableField("deleted")
    private Integer deleted;
}