package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 短信发送记录 实体类
 */
@Data
@TableName("ice_sms_alarm_send_record")
public class SmsAlarmSendRecord implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 车场编号
     */
    @TableField("park_code")
    private String parkCode;

    /**
     * 月卡名称
     */
    @TableField("product_name")
    private String productName;
    /**
     * 短信类型(1-月卡临期提醒;2-特殊车辆提醒开关)
     */
    @TableField("sms_type")
    private Integer smsType;
    /**
     * 收信手机号
     */
    @TableField("recv_phone")
    private String recvPhone;
    /**
     * 短信内容
     */
    @TableField("sms_content")
    private String smsContent;
    /**
     * 车牌号
     */
    @TableField("plate_nums")
    private String plateNums;
    /**
     * 设备类型(1-出入口识别相机;2-对讲柱;3-光缆追缴监控相机)
     */
    @TableField("device_type")
    private Integer deviceType;
    /**
     * 通道ID
     */
    @TableField("channel_id")
    private Integer channelId;
    /**
     * 发送时间
     */
    @TableField("send_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sendTime;
    /**
     *
     */
    @TableField("sms_count")
    private Integer smsCount;
    /**
     *
     */
    @TableField("send_no")
    private String sendNo;
    /**
     *  发送状态  0-失败，1-成功
     */
    @TableField("send_seq")
    private Integer sendSeq;
    /**
     *
     */
    @TableField("ref_data_id")
    private String refDataId;
    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
}