package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 短信车场配置表 实体类
 */
@Data
@TableName("ice_sms_alarm_config")
public class SmsAlarmConfig implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 车场编号
     */
    @TableField("park_code")
    private String parkCode;
    /**
     * 月卡临期提醒开关(0-关闭;1-开启)
     */
    @TableField("month_enable_flag")
    private Integer monthEnableFlag;
    /**
     * 特殊车辆提醒开关(0-关闭;1-开启)
     */
    @TableField("spec_veh_enable_flag")
    private Integer specVehEnableFlag;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
}