package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;


import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 订单表 实体类
 */
@Data
@TableName("ice_order")
public class RoadOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;
    /**
     * 所属道路id
     */
    @TableField("park_id")
    private Integer parkId;
    /**
     * 订单号
     */
    @TableField("order_num")
    private String orderNum;
    /**
     * 第三方记录ID
     */
    @TableField("vendor_record_id")
    private String vendorRecordId;
    /**
     * 泊位id
     */
    @TableField("berth_id")
    private Integer berthId;
    /**
     * 车牌号
     */
    @TableField("plate_num")
    private String plateNum;
    /**
     * 车辆类型（1：临时车，99：未知，默认1）
     */
    @TableField("card_type")
    private Integer cardType;
    /**
     * 进场时间
     */
    @TableField("enter_time")
    private Long enterTime;
    /**
     * 离场时间
     */
    @TableField("exit_time")
    private Long exitTime;
    /**
     * 停车时长(秒)
     */
    @TableField("park_duration")
    private Integer parkDuration;
    /**
     * 上报时间
     */
    @TableField("report_time")
    private Long reportTime;
    /**
     * 车型（1：小型车，2：大型车，默认1）
     */
    @TableField("car_type")
    private Integer carType;
    /**
     * 特殊类型ID
     */
    @TableField("card_type_id")
    private Integer cardTypeId;
    /**
     * 订单金额
     */
    @TableField("total_price")
    private BigDecimal totalPrice;
    /**
     * 已缴金额
     */
    @TableField("paid_price")
    private BigDecimal paidPrice;
    /**
     * 待缴金额
     */
    @TableField("unpaid_price")
    private BigDecimal unpaidPrice;
    /**
     * 优惠金额
     */
    @TableField("discount_price")
    private BigDecimal discountPrice;
    /**
     * 退款金额
     */
    @TableField("refund_price")
    private BigDecimal refundPrice;
    /**
     * 退款标识(0-未退款;1-有退款)
     */
    @TableField("refund_flag")
    private Integer refundFlag;
    /**
     * 订单类型（1：在场，2：离场）
     */
    @TableField("order_type")
    private Integer orderType;
    /**
     * 订单状态（1：正常，2：已取消，3：异常，默认1）
     */
    @TableField("order_status")
    private Integer orderStatus;
    /**
     * 异常或取消原因（order_type=2或3是必填）
     */
    @TableField("error_causes")
    private String errorCauses;
    /**
     * 缴费状态（1：未缴费2：预交费中，3：欠费，4：已缴费，5：无需缴费，6：未知）
     */
    @TableField("pay_status")
    private Integer payStatus;
    /**
     * 入场方式（1：高位视频，2：地磁，3：pos机，4：人工手动，5：巡检车）
     */
    @TableField("enter_way")
    private Integer enterWay;
    /**
     * 入场设备
     */
    @TableField("enter_device")
    private String enterDevice;
    /**
     * 离场方式（1：高位视频，2：地磁，3：pos机，4：人工手动，5：巡检车，6：自动离场）
     */
    @TableField("exit_way")
    private Integer exitWay;
    /**
     * 离场设备
     */
    @TableField("exit_device")
    private String exitDevice;
    /**
     * 车牌颜色
     */
    @TableField("plate_color")
    private Integer plateColor;
    /**
     * 入场推送结果(0：未上传；9：上传成功；-9：上传失败)
     */
    @TableField("push_enter_result")
    private Integer pushEnterResult;
    /**
     * 出场推送结果(0：未上传；9：上传成功；-9：上传失败)
     */
    @TableField("push_exit_result")
    private Integer pushExitResult;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 添加人
     */
    @TableField("adder")
    private String adder;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
    /**
     * 更新人
     */
    @TableField("update_user")
    private String updateUser;
    /**
     * 描述信息
     */
    @TableField("remark")
    private String remark;
    /**
     * 开票状态（0：未开票；1：开票中；2：开票成功；-2：开票失败）
     */
    @TableField("invoice_status")
    private Integer invoiceStatus;
    /**
     * 最后打印用户
     */
    @TableField("last_print_user")
    private String lastPrintUser;
    /**
     * 最后打印时间
     */
    @TableField("last_print_time")
    private Date lastPrintTime;
}